/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import lambda.Options;

class LambdaText {
    public static final char LAMBDA = '\u03bb';

    LambdaText() {
    }

    private static Document createDocument(Document document) {
        if (document != null && document instanceof PlainDocument) {
            PlainDocument plainDocument = (PlainDocument)document;
            plainDocument.setDocumentFilter(new MyDocumentFilter());
        }
        return document;
    }

    static JTextField createTextField(int n) {
        return new TextField(n);
    }

    static JTextArea createTextArea() {
        return new TextArea();
    }

    private static class TextArea
    extends JTextArea {
        TextArea() {
            Options.getPrintLambdaOption().addListener(new LambdaListener(this));
            super.setDocument(LambdaText.createDocument(this.getDocument()));
        }

        public void setDocument(Document document) {
            super.setDocument(LambdaText.createDocument(document));
        }
    }

    private static class TextField
    extends JTextField {
        TextField(int n) {
            super(n);
            Options.getPrintLambdaOption().addListener(new LambdaListener(this));
            super.setDocument(LambdaText.createDocument(this.getDocument()));
        }

        public void setDocument(Document document) {
            super.setDocument(LambdaText.createDocument(document));
        }
    }

    private static class LambdaListener
    implements Options.Listener {
        private JTextComponent item;
        private char last_lambda = (char)63;

        LambdaListener(JTextComponent jTextComponent) {
            this.item = jTextComponent;
        }

        public void valueChanged(Options.Option option) {
            this.item.setText(this.item.getText().replace('\u03bb', '\\'));
        }
    }

    private static class MyDocumentFilter
    extends DocumentFilter {
        private MyDocumentFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char c = Options.getLambdaChar();
            if (c != '\\') {
                string = string.replace('\\', c);
            }
            super.insertString(filterBypass, n, string, attributeSet);
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            super.remove(filterBypass, n, n2);
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            char c = Options.getLambdaChar();
            if (c != '\\') {
                string = string.replace('\\', c);
            }
            super.replace(filterBypass, n, n2, string, attributeSet);
        }
    }
}

