/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HelpFrame
extends JFrame
implements HyperlinkListener {
    protected JMenu menu_file;
    protected JMenu menu_go;
    protected JEditorPane editor;
    protected JScrollPane scroll_pane;
    protected History history = new History();
    protected URL base_url = null;

    public HelpFrame(String string) {
        super("Help");
        this.setSize(500, 400);
        JMenuBar jMenuBar = new JMenuBar();
        this.menu_file = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.hide();
            }
        });
        this.menu_file.add(jMenuItem);
        jMenuBar.add(this.menu_file);
        this.menu_go = new JMenu("Go");
        jMenuItem = new JMenuItem("Back");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.history.back();
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 8));
        this.menu_go.add(jMenuItem);
        jMenuItem = new JMenuItem("Forward");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.history.forward();
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        this.menu_go.add(jMenuItem);
        this.menu_go.addSeparator();
        jMenuBar.add(this.menu_go);
        this.setJMenuBar(jMenuBar);
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        this.editor.setContentType("text/html");
        this.editor.addHyperlinkListener(this);
        this.scroll_pane = new JScrollPane(this.editor);
        this.scroll_pane.setVerticalScrollBarPolicy(22);
        this.scroll_pane.setMinimumSize(new Dimension(10, 10));
        this.getContentPane().add(this.scroll_pane);
        try {
            this.computeBaseURL();
            this.history.init(new URL(this.base_url, string));
        }
        catch (Exception exception) {
            this.showError("Initialization error: " + exception.getMessage());
        }
    }

    private void computeBaseURL() throws Exception {
        String string = System.getProperty("java.class.path");
        if (string == null) {
            throw new Exception("can't determine help base location");
        }
        File file = new File(string);
        if (file.isDirectory()) {
            this.base_url = new URL("file:" + file + "/index.html");
        } else if (file.exists()) {
            this.base_url = new URL("jar:file:" + file + "!/index.html");
        } else {
            throw new Exception("can't find help base location");
        }
    }

    public void addContentsItem(String string, URL uRL) {
        this.menu_go.add(new ContentMenuItem(string, uRL));
    }

    protected void showError(String string) {
        this.editor.setText("<h1>Error</h1>\n<p>" + string + "</p>\n");
    }

    public URL getCurrent() {
        return this.history.getCurrent();
    }

    public void load(String string) {
        try {
            this.load(new URL(this.base_url, string));
        }
        catch (IOException iOException) {
            this.showError("Could not find file: " + iOException.getMessage());
        }
    }

    public void load(URL uRL) {
        this.history.addURL(uRL);
    }

    protected boolean getURL(URL uRL) {
        try {
            try {
                HTMLDocument hTMLDocument = (HTMLDocument)this.editor.getDocument();
                hTMLDocument.setBase(uRL);
                this.load(uRL.openStream());
            }
            catch (IOException iOException) {
                throw new Exception("Couldn't open URL " + uRL + " (protocol " + uRL.getProtocol() + "): " + iOException.getMessage());
            }
            return true;
        }
        catch (Throwable throwable) {
            this.showError(throwable.getMessage());
            return false;
        }
    }

    protected void load(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.editor.getEditorKit().createDefaultDocument();
        this.editor.setText(stringBuffer.toString());
        this.editor.setCaretPosition(0);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                try {
                    URL uRL = hyperlinkEvent.getURL();
                    if (uRL == null) {
                        uRL = new URL(this.history.getCurrent(), hyperlinkEvent.getDescription());
                    }
                    this.load(uRL);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    protected class History {
        LinkedList urls = new LinkedList();
        protected int pos = -1;

        protected History() {
        }

        public void init(URL uRL) {
            this.pos = 0;
            this.urls.add(uRL);
            HelpFrame.this.getURL(uRL);
        }

        public URL getCurrent() {
            return (URL)this.urls.get(this.pos);
        }

        public void back() {
            if (this.pos - 1 >= 0) {
                --this.pos;
                HelpFrame.this.getURL((URL)this.urls.get(this.pos));
            }
        }

        public void forward() {
            if (this.pos + 1 < this.urls.size()) {
                ++this.pos;
                HelpFrame.this.getURL((URL)this.urls.get(this.pos));
            }
        }

        public void addURL(URL uRL) {
            if (HelpFrame.this.getURL(uRL)) {
                while (this.urls.size() > this.pos + 1) {
                    this.urls.remove(this.pos + 1);
                }
                this.urls.add(uRL);
                this.pos = this.urls.size() - 1;
            }
        }
    }

    protected class ContentMenuItem
    extends JMenuItem
    implements ActionListener {
        URL url;

        public ContentMenuItem(String string, URL uRL) {
            super(string);
            this.url = uRL;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpFrame.this.load(this.url);
        }
    }
}

