/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import lambda.Context;
import lambda.ExprWrapper;
import lambda.Symbol;

abstract class Expr {
    private static char[] left_parens = "(([(({".toCharArray();
    private static char[] right_parens = "))]))}".toCharArray();

    Expr() {
    }

    abstract Object visit(Visitor var1);

    abstract Object visitP(VisitorP var1, Object var2);

    abstract void addBounds(HashSet var1, HashSet var2);

    abstract boolean uses(Symbol var1);

    abstract int size();

    public String toString() {
        return this.toString(null, Integer.MAX_VALUE, false);
    }

    public String toString(Context context) {
        return this.toString(context, Integer.MAX_VALUE, false);
    }

    public String toString(Context context, int n, boolean bl) {
        PrintVisitor printVisitor = new PrintVisitor(this, context, n, bl, true);
        this.visitP(printVisitor, Boolean.FALSE);
        return printVisitor.output.toString();
    }

    public String toStringSubstituteBelow(Context context, int n, boolean bl) {
        PrintVisitor printVisitor = new PrintVisitor(this, context, n, bl, false);
        this.visitP(printVisitor, Boolean.FALSE);
        return printVisitor.output.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Expr) {
            return this == object;
        }
        if (object instanceof ExprWrapper) {
            return ((ExprWrapper)object).equals(this);
        }
        return false;
    }

    private static class PrintVisitor
    implements VisitorP {
        boolean substitute_at_top = true;
        Context context;
        int max_len;
        boolean vary_parens;
        StringBuffer output = new StringBuffer();
        int paren_depth = 0;
        int paren_cur = -1;
        HashSet bounds = new HashSet();
        HashSet frees = new HashSet();
        HashSet free_names = new HashSet();
        HashSet ident_names = new HashSet();
        HashMap sym_map = new HashMap();
        boolean exceeded = false;
        int last_alloc = -1;
        boolean visited = false;

        PrintVisitor(Expr expr, Context context, int n, boolean bl, boolean bl2) {
            Symbol symbol;
            this.context = context;
            this.max_len = n;
            this.vary_parens = bl;
            this.substitute_at_top = bl2;
            expr.addBounds(this.bounds, this.frees);
            Iterator iterator = this.frees.iterator();
            while (iterator.hasNext()) {
                symbol = (Symbol)iterator.next();
                this.free_names.add(symbol.toString());
                this.ident_names.add(symbol.toString());
            }
            iterator = this.bounds.iterator();
            while (iterator.hasNext()) {
                symbol = (Symbol)iterator.next();
                this.ident_names.add(symbol.toString());
            }
        }

        private String allocate() {
            String string;
            while (this.last_alloc >= 0 && !this.ident_names.contains("i" + this.last_alloc)) {
                --this.last_alloc;
            }
            do {
                ++this.last_alloc;
            } while (this.ident_names.contains(string = "i" + this.last_alloc));
            return string;
        }

        private char getLeftParen() {
            ++this.paren_depth;
            if (!this.vary_parens) {
                return '(';
            }
            ++this.paren_cur;
            if (this.paren_cur == left_parens.length) {
                this.paren_cur = 0;
            }
            return left_parens[this.paren_cur];
        }

        private char getRightParen() {
            --this.paren_depth;
            if (!this.vary_parens) {
                return ')';
            }
            char c = right_parens[this.paren_cur];
            --this.paren_cur;
            if (this.paren_cur < 0) {
                this.paren_cur = right_parens.length - 1;
            }
            return c;
        }

        private boolean append(char c) {
            return this.append("" + c);
        }

        private boolean append(String string) {
            if (this.output.length() + string.length() + this.paren_depth + 5 <= this.max_len && !this.exceeded) {
                this.output.append(string);
                return true;
            }
            if (!this.exceeded) {
                this.output.append(" ... ");
                this.exceeded = true;
                return false;
            }
            return false;
        }

        boolean checkForSubstitution(Expr expr) {
            if (this.context != null) {
                String string;
                if ((this.substitute_at_top || this.visited) && (string = this.context.invert(expr)) != null) {
                    this.append(string);
                    return true;
                }
                this.visited = true;
            }
            return false;
        }

        public Object visitAbstract(Abstract abstract_, Object object) {
            if (this.exceeded) {
                return null;
            }
            if (this.checkForSubstitution(abstract_)) {
                return null;
            }
            String string = abstract_.sym.toString();
            if (this.free_names.contains(string)) {
                string = this.allocate();
                this.sym_map.put(abstract_.sym, string);
            }
            this.free_names.add(string);
            this.ident_names.add(string);
            boolean bl = false;
            if (object == Boolean.TRUE) {
                bl = this.append(this.getLeftParen());
            }
            this.append("\\" + string + ".");
            abstract_.expr.visitP(this, Boolean.FALSE);
            if (object == Boolean.TRUE) {
                if (bl) {
                    this.output.append(this.getRightParen());
                } else {
                    this.getRightParen();
                }
            }
            this.free_names.remove(string);
            this.ident_names.remove(string);
            if (string != abstract_.sym.toString()) {
                this.sym_map.remove(abstract_.sym);
            }
            return null;
        }

        public Object visitApply(Apply apply, Object object) {
            if (this.exceeded) {
                return null;
            }
            if (this.checkForSubstitution(apply)) {
                return null;
            }
            apply.left.visitP(this, Boolean.TRUE);
            this.append(" ");
            if (apply.right instanceof Apply) {
                boolean bl = this.append(this.getLeftParen());
                apply.right.visitP(this, Boolean.FALSE);
                if (bl) {
                    this.output.append(this.getRightParen());
                } else {
                    this.getRightParen();
                }
            } else {
                apply.right.visitP(this, Boolean.TRUE);
            }
            return null;
        }

        public Object visitIdent(Ident ident, Object object) {
            if (this.checkForSubstitution(ident)) {
                return null;
            }
            String string = (String)this.sym_map.get(ident.sym);
            this.append(string != null ? string : ident.sym.toString());
            return null;
        }
    }

    static class Ident
    extends Expr {
        final Symbol sym;

        Ident(Symbol symbol) {
            this.sym = symbol;
        }

        void addBounds(HashSet hashSet, HashSet hashSet2) {
            if (!hashSet.contains(this.sym)) {
                hashSet2.add(this.sym);
            }
        }

        Object visit(Visitor visitor) {
            return visitor.visitIdent(this);
        }

        Object visitP(VisitorP visitorP, Object object) {
            return visitorP.visitIdent(this, object);
        }

        int size() {
            return 1;
        }

        boolean uses(Symbol symbol) {
            return this.sym == symbol;
        }
    }

    static class Apply
    extends Expr {
        final Expr left;
        final Expr right;

        Apply(Expr expr, Expr expr2) {
            this.left = expr;
            this.right = expr2;
        }

        void addBounds(HashSet hashSet, HashSet hashSet2) {
            this.left.addBounds(hashSet, hashSet2);
            this.right.addBounds(hashSet, hashSet2);
        }

        Object visit(Visitor visitor) {
            return visitor.visitApply(this);
        }

        Object visitP(VisitorP visitorP, Object object) {
            return visitorP.visitApply(this, object);
        }

        int size() {
            return 1 + this.left.size() + this.right.size();
        }

        boolean uses(Symbol symbol) {
            return this.left.uses(symbol) || this.right.uses(symbol);
        }
    }

    static class Abstract
    extends Expr {
        final Symbol sym;
        final Expr expr;

        Abstract(Symbol symbol, Expr expr) {
            this.sym = symbol;
            this.expr = expr;
        }

        void addBounds(HashSet hashSet, HashSet hashSet2) {
            hashSet.add(this.sym);
            this.expr.addBounds(hashSet, hashSet2);
        }

        Object visit(Visitor visitor) {
            return visitor.visitAbstract(this);
        }

        Object visitP(VisitorP visitorP, Object object) {
            return visitorP.visitAbstract(this, object);
        }

        int size() {
            return 1 + this.expr.size();
        }

        boolean uses(Symbol symbol) {
            return this.expr.uses(symbol);
        }
    }

    static interface VisitorP {
        public Object visitAbstract(Abstract var1, Object var2);

        public Object visitApply(Apply var1, Object var2);

        public Object visitIdent(Ident var1, Object var2);
    }

    static interface Visitor {
        public Object visitAbstract(Abstract var1);

        public Object visitApply(Apply var1);

        public Object visitIdent(Ident var1);
    }
}

