/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import lambda.Context;
import lambda.Expr;
import lambda.ExprWrapper;
import lambda.Gui;
import lambda.Options;
import lambda.Parser;
import lambda.Simplify;

class Engine {
    private static int RUNNER_IDLE = 0;
    private static int RUNNER_REQUEST_READY = 1;
    private static int RUNNER_COMPUTING = 2;
    private static int RUNNER_REQUEST_MADE = 3;
    private static int RUNNER_CANCELED = 4;
    private Gui gui;
    private Runner runner = null;

    Engine(Gui gui) {
        this.gui = gui;
    }

    void addDefinition(String string, String string2) {
        if (this.runner == null) {
            this.runner = new Runner();
            this.runner.start();
        }
        this.runner.requestProcessing(string, string2);
    }

    private Expr process(String string) {
        Expr expr;
        JTextArea jTextArea = this.gui.getOutputArea();
        Context context = this.gui.getContext();
        Context context2 = null;
        if (Options.getSubstituteSymbolsOption().getValue()) {
            context2 = context;
        }
        boolean bl = Options.getVaryParenthesesOption().getValue();
        boolean bl2 = Options.getShowIntermediateOption().getValue();
        int n = Options.getMaxLengthOption().getValue();
        try {
            expr = Parser.parse(string);
        }
        catch (Parser.ParseException parseException) {
            jTextArea.setText(parseException.getMessage());
            return null;
        }
        if (this.runner.state == RUNNER_CANCELED) {
            return null;
        }
        expr = context.substitute(expr);
        jTextArea.setText(expr.toStringSubstituteBelow(context2, n, bl));
        Expr expr2 = expr;
        Expr expr3 = expr;
        int n2 = expr.size();
        Expr expr4 = Simplify.simplify(expr);
        HashSet<ExprWrapper> hashSet = new HashSet<ExprWrapper>();
        Expr[] exprArray = new Expr[100];
        int n3 = -1;
        int n4 = 0;
        while (expr4 != expr) {
            expr = expr4;
            if (bl2) {
                jTextArea.append("\n   = ");
                jTextArea.append(expr.toString(context2, n, bl));
            }
            int n5 = expr.size();
            ExprWrapper exprWrapper = new ExprWrapper(expr);
            if (this.runner.state == RUNNER_CANCELED || ++n4 > Options.getMaxReductionsOption().getValue() || hashSet.contains(exprWrapper)) {
                jTextArea.append("\n   = ... ");
                expr = expr3;
                jTextArea.append(expr.toString(context2, n, bl));
                break;
            }
            if (++n3 == exprArray.length) {
                n3 = 0;
            }
            if (exprArray[n3] != null) {
                hashSet.remove(exprArray[n3]);
            }
            exprArray[n3] = expr;
            hashSet.add(exprWrapper);
            if (n5 < n2) {
                expr3 = expr;
                n2 = n5;
            }
            expr4 = Simplify.simplify(expr);
        }
        if (!bl2) {
            jTextArea.append("\n   = ");
            jTextArea.append(expr.toString(context2, n, bl));
        }
        return expr;
    }

    private class Runner
    extends Thread {
        int state = Engine.access$000();
        String name;
        String expr;

        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                String string;
                String string2;
                Runner runner = this;
                synchronized (runner) {
                    while (this.state != RUNNER_REQUEST_READY) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    string2 = this.name;
                    string = this.expr;
                    this.state = RUNNER_COMPUTING;
                }
                Expr expr = Engine.this.process(string);
                Runner runner2 = this;
                synchronized (runner2) {
                    while (this.state == RUNNER_REQUEST_MADE) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.state != RUNNER_CANCELED && !string2.equals("") && expr != null) {
                        Engine.this.gui.getContext().put(string2, expr);
                    }
                    this.name = null;
                    this.expr = null;
                    this.state = RUNNER_IDLE;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void requestProcessing(String string, String string2) {
            Object[] objectArray;
            boolean bl = false;
            Object[] objectArray2 = this;
            // MONITORENTER : objectArray2
            if (this.name != null && string.equals(this.name) && string2.equals(this.expr)) {
                // MONITOREXIT : objectArray2
                return;
            }
            if (this.state == RUNNER_COMPUTING) {
                this.state = RUNNER_REQUEST_MADE;
                bl = true;
            }
            // MONITOREXIT : objectArray2
            if (bl) {
                objectArray = new Object[]{"Cancel Computation", "Cancel Request"};
                int n = JOptionPane.showOptionDialog(Engine.this.gui, "Cannot process request while computation is already in progress.", "Cannot Process Request", -1, 3, null, objectArray, objectArray[0]);
                Object[] objectArray3 = this;
                // MONITORENTER : objectArray3
                if (n != 0) {
                    this.state = RUNNER_COMPUTING;
                    this.notifyAll();
                    // MONITOREXIT : objectArray3
                    return;
                }
                this.state = RUNNER_CANCELED;
                this.notifyAll();
                // MONITOREXIT : objectArray3
            }
            objectArray = this;
            // MONITORENTER : objectArray
            while (this.state != RUNNER_IDLE) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.name = string;
            this.expr = string2;
            this.state = RUNNER_REQUEST_READY;
            this.notifyAll();
            // MONITOREXIT : objectArray
        }
    }
}

