/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import lambda.Expr;
import lambda.ExprWrapper;
import lambda.Parser;
import lambda.Symbol;
import lambda.TreeSetSeq;

class Context
implements ListModel {
    private HashMap map = new HashMap();
    private HashMap inverse = new HashMap();
    private TreeSetSeq names = new TreeSetSeq();
    private LinkedList listeners = new LinkedList();

    Context() {
    }

    Expr substitute(Expr expr) {
        return (Expr)expr.visit(new Substitutor());
    }

    void put(String string, Expr expr) {
        if (this.insert(string = string.trim(), expr)) {
            int n = this.names.getIndex((Comparable)((Object)string));
            this.fireEvent(1, n, n);
        }
    }

    Expr get(String string) {
        return (Expr)this.map.get(string.trim());
    }

    String invert(Expr expr) {
        String string = (String)this.inverse.get(new ExprWrapper(expr));
        return string;
    }

    private boolean insert(String string, Expr expr) {
        boolean bl = true;
        Expr expr2 = (Expr)this.map.get(string);
        if (expr2 == null) {
            this.names.add((Comparable)((Object)string));
        } else {
            this.inverse.remove(new ExprWrapper(expr2));
            bl = false;
        }
        this.map.put(string, expr);
        this.inverse.put(new ExprWrapper(expr), string);
        return bl;
    }

    void exportFile(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            printWriter.println(string);
            printWriter.println("  " + this.map.get(string));
        }
        printWriter.close();
    }

    void importFile(File file) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        while (true) {
            int n = lineNumberReader.getLineNumber();
            String string = lineNumberReader.readLine();
            if (string == null) break;
            if (string.length() == 0 || string.charAt(0) == ' ') {
                lineNumberReader.close();
                throw new IOException(n + ": expected symbol definition");
            }
            String string2 = lineNumberReader.readLine();
            if (string2 == null || string2.length() == 0 || string2.charAt(0) != ' ') {
                lineNumberReader.close();
                throw new IOException(n + ": symbol " + string + " missing definition");
            }
            try {
                this.insert(string, Parser.parse(string2));
            }
            catch (Parser.ParseException parseException) {
                lineNumberReader.close();
                throw new IOException(n + 1 + ": expression parse: " + parseException.getMessage());
            }
        }
        lineNumberReader.close();
        this.fireEvent(0, 0, this.names.size());
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    public Object getElementAt(int n) {
        return this.names.get(n);
    }

    public int getSize() {
        return this.names.size();
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove(listDataListener);
    }

    private void fireEvent(int n, int n2, int n3) {
        ListDataEvent listDataEvent = new ListDataEvent(this, n, n2, n3);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ListDataListener listDataListener = (ListDataListener)iterator.next();
            if (n == 0) {
                listDataListener.contentsChanged(listDataEvent);
                continue;
            }
            if (n == 1) {
                listDataListener.intervalAdded(listDataEvent);
                continue;
            }
            if (n != 2) continue;
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    private class Substitutor
    implements Expr.Visitor {
        private Substitutor() {
        }

        public Object visitAbstract(Expr.Abstract abstract_) {
            Expr expr = null;
            String string = abstract_.sym.toString();
            Symbol symbol = abstract_.sym;
            if (Context.this.map.containsKey(string)) {
                expr = (Expr)Context.this.map.get(string);
                Context.this.map.remove(string);
            }
            Expr.Abstract abstract_2 = new Expr.Abstract(symbol, (Expr)abstract_.expr.visit(this));
            if (symbol != abstract_.sym) {
                Context.this.map.put(string, expr);
            }
            return abstract_2;
        }

        public Object visitApply(Expr.Apply apply) {
            return new Expr.Apply((Expr)apply.left.visit(this), (Expr)apply.right.visit(this));
        }

        public Object visitIdent(Expr.Ident ident) {
            Expr expr = (Expr)Context.this.map.get(ident.sym.toString());
            if (expr != null) {
                return expr;
            }
            return ident;
        }
    }
}

